#version 140
#extension GL_EXT_gpu_shader4 : enable
//RoundRainDropsMod01.fsh by MelisaHot
//https://www.shadertoy.com/view/ssXfWX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed* 0.3141592
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)
vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;










// s is smoothstep
#define S(x, y, t) smoothstep(x, y, t)


struct ray {
	vec3 o, d; // ray origin and direction 
};

//function for random numer 
float N(float t){
    return fract(sin(t*3456.)*6547.); // noise function -- random number
}

//random numer - 1 imput 4 out
vec4 N14(float t){
    return fract(sin(t*vec4(123., 1024., 3456., 9564.))*vec4(6547., 345., 8799., 1564.)); // noise function -- random number
}

ray CameraSetup(vec2 uv, vec3 camPos, vec3 lookAt, float zoom) {
	ray cam;
    cam.o = camPos;
    
    vec3 f = normalize(lookAt-cam.o); // forward vec
    vec3 r = cross(vec3(0., 1., 0.), f); // right vec
    vec3 u = cross(f, r); // up vec
    
    vec3 c = cam.o + f * zoom; // center of screen
    vec3 i = c + uv.x*r + uv.y*u; // itersection point
    
    cam.d = normalize(i-cam.o); 
    
    return cam;
}
  

vec2 Rain(vec2 uv, float t){
    
    t *=40.;
   
    vec2 a= vec2(3., 1); // aspect ratio
    vec2 st = uv*a;
    vec2 id= floor(st);
    st.y+=t*.22;
    float rand= fract(sin(id.x*716.34)*768.34); //random number
    st.y+=rand;
    uv.y+=rand;
   
    id= floor(st);
    st = fract(st)-0.5; // to save value of uv
     uv.x +=sin(uv.y*300.)*.002;
    t +=fract(sin(id.x*76.34*id.y*1453.7)*768.34)*6.287;
    float y = -sin(t+sin(t+sin(t)*0.5))*.43;
    
    vec2 p1=vec2(0., y);
    vec2 o1= (st-p1)/a;
    float d = length(o1); // distance of pixel from the center of the box
    
    float m1 = S(.07,.0, d);
    vec2 o2=(fract(uv*a.x*vec2(1., 2.))-.5)/vec2(1., 2.);
    d = length(o2);
    
    
    float m2 = S(.3*(.5-st.y),.0, d)*S(-.1, .1, st.y-p1.y);
   // if(st.x>.46 || st.y>.49) m1=1.;
   
 
    return vec2(m1*o1*30.+m2*o2*10.);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= .5;
    uv.x *= iResolution.x/iResolution.y;
    
    vec3 camPos = vec3(0., 0., 0.); //position of camera
    vec3 lookAt = vec3(0., 0., 1); // position of lookat point 
    
    vec2 mouse = iMouse.xy / iResolution.xy;
    float t = iTime*.05 +mouse.x;
    
    vec2 rainDistort = Rain(uv*5., t)*0.5;
    rainDistort += Rain(uv*11., t)*0.5;
    rainDistort += Rain(uv*3., t)*0.5;
    uv.x +=sin(uv.y*50.)*.002;
   // uv.y +=sin(uv.x*170.)*.002;*/
    ray r = CameraSetup(uv - rainDistort*.5, camPos, lookAt, 2.);
    
   vec4 col = texture(iChannel0,uv);
   col += (r.d.y*2.);

  gl_FragColor = vec4(col); // Output to screen
}